package gov.va.med.mhv.sm.admin.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.Type;

import gov.va.med.mhv.sm.admin.model.AbstractBaseEntity;

@Entity
@Table(name = "MESSAGE_THREAD")
@DynamicUpdate(value=true)
@SelectBeforeUpdate(value=true) 
public class Thread extends AbstractBaseEntity{

	private static final long serialVersionUID = 828013738220258892L;
	
	@Id
	@Column(name = "THREAD_ID")
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sequence")
	@SequenceGenerator(name="sequence", sequenceName="GEN_SMS_SEQ")
	private Long id;
	
	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@ManyToOne
	@Fetch(FetchMode.SELECT)
	@JoinColumn(name = "TRIAGE_GROUP_ID")
	private TriageGroup mailGroup;

	@Column(name = "CATEGORY_TYPE")
	private Long messageCategoryTypeId;
	
	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "SUBJECT")
	private String subject;
	
	@Column(name = "TRIAGE_GROUP_ID", insertable = false, updatable = false)
	private Long triageGroupId;

	public Thread(){
		this.active=true;
		createdDate = new Date();
		modifiedDate = new Date();
	}
	
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public TriageGroup getMailGroup() {
		return mailGroup;
	}

	public void setMailGroup(TriageGroup mailGroup) {
		this.mailGroup = mailGroup;
	}

	public Long getMessageCategoryTypeId() {
		return messageCategoryTypeId;
	}

	public void setMessageCategoryTypeId(Long messageCategoryTypeId) {
		this.messageCategoryTypeId = messageCategoryTypeId;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public Long getTriageGroupId() {
		return triageGroupId;
	}

	public void setTriageGroupId(Long triageGroupId) {
		this.triageGroupId = triageGroupId;
	}

}
